@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureActiveDirectoryValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active Directory token validation flow.
 * @property allowedAudiences The list of audiences that can make successful authentication/authorization requests.
 * @property defaultAuthorizationPolicy The configuration settings of the default authorization policy.
 * @property jwtClaimChecks The configuration settings of the checks that should be made while validating the JWT Claims.
 */
public data class AzureActiveDirectoryValidationArgs(
    public val allowedAudiences: Output<List<String>>? = null,
    public val defaultAuthorizationPolicy: Output<DefaultAuthorizationPolicyArgs>? = null,
    public val jwtClaimChecks: Output<JwtClaimChecksArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureActiveDirectoryValidationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureActiveDirectoryValidationArgs =
        com.pulumi.azurenative.web.inputs.AzureActiveDirectoryValidationArgs.builder()
            .allowedAudiences(allowedAudiences?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultAuthorizationPolicy(
                defaultAuthorizationPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jwtClaimChecks(
                jwtClaimChecks?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureActiveDirectoryValidationArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryValidationArgsBuilder internal constructor() {
    private var allowedAudiences: Output<List<String>>? = null

    private var defaultAuthorizationPolicy: Output<DefaultAuthorizationPolicyArgs>? = null

    private var jwtClaimChecks: Output<JwtClaimChecksArgs>? = null

    /**
     * @param value The list of audiences that can make successful authentication/authorization requests.
     */
    @JvmName("niclbgewkmtahauj")
    public suspend fun allowedAudiences(`value`: Output<List<String>>) {
        this.allowedAudiences = value
    }

    @JvmName("tvrciibbgfwyifih")
    public suspend fun allowedAudiences(vararg values: Output<String>) {
        this.allowedAudiences = Output.all(values.asList())
    }

    /**
     * @param values The list of audiences that can make successful authentication/authorization requests.
     */
    @JvmName("oxbvptvmqedrctsi")
    public suspend fun allowedAudiences(values: List<Output<String>>) {
        this.allowedAudiences = Output.all(values)
    }

    /**
     * @param value The configuration settings of the default authorization policy.
     */
    @JvmName("aginywkaamnykacg")
    public suspend fun defaultAuthorizationPolicy(`value`: Output<DefaultAuthorizationPolicyArgs>) {
        this.defaultAuthorizationPolicy = value
    }

    /**
     * @param value The configuration settings of the checks that should be made while validating the JWT Claims.
     */
    @JvmName("blcmrovrnfuvdaax")
    public suspend fun jwtClaimChecks(`value`: Output<JwtClaimChecksArgs>) {
        this.jwtClaimChecks = value
    }

    /**
     * @param value The list of audiences that can make successful authentication/authorization requests.
     */
    @JvmName("ybycuvckhtuiockn")
    public suspend fun allowedAudiences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param values The list of audiences that can make successful authentication/authorization requests.
     */
    @JvmName("sqxnypmdpehbycot")
    public suspend fun allowedAudiences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedAudiences = mapped
    }

    /**
     * @param value The configuration settings of the default authorization policy.
     */
    @JvmName("igcqmlsblndxjbdg")
    public suspend fun defaultAuthorizationPolicy(`value`: DefaultAuthorizationPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAuthorizationPolicy = mapped
    }

    /**
     * @param argument The configuration settings of the default authorization policy.
     */
    @JvmName("pejefrpibbfqtobg")
    public suspend
    fun defaultAuthorizationPolicy(argument: suspend DefaultAuthorizationPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultAuthorizationPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAuthorizationPolicy = mapped
    }

    /**
     * @param value The configuration settings of the checks that should be made while validating the JWT Claims.
     */
    @JvmName("bkplwhvkjtculdpq")
    public suspend fun jwtClaimChecks(`value`: JwtClaimChecksArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jwtClaimChecks = mapped
    }

    /**
     * @param argument The configuration settings of the checks that should be made while validating the JWT Claims.
     */
    @JvmName("unrhwylqtactsfwd")
    public suspend fun jwtClaimChecks(argument: suspend JwtClaimChecksArgsBuilder.() -> Unit) {
        val toBeMapped = JwtClaimChecksArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jwtClaimChecks = mapped
    }

    internal fun build(): AzureActiveDirectoryValidationArgs = AzureActiveDirectoryValidationArgs(
        allowedAudiences = allowedAudiences,
        defaultAuthorizationPolicy = defaultAuthorizationPolicy,
        jwtClaimChecks = jwtClaimChecks,
    )
}
