@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.CapabilityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the capabilities/features allowed for a specific SKU.
 * @property name Name of the SKU capability.
 * @property reason Reason of the SKU capability.
 * @property value Value of the SKU capability.
 */
public data class CapabilityArgs(
    public val name: Output<String>? = null,
    public val reason: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.CapabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.CapabilityArgs =
        com.pulumi.azurenative.web.inputs.CapabilityArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .reason(reason?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapabilityArgs].
 */
@PulumiTagMarker
public class CapabilityArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var reason: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the SKU capability.
     */
    @JvmName("omptewpivsxqwsmb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reason of the SKU capability.
     */
    @JvmName("lkcganktefkisnig")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value Value of the SKU capability.
     */
    @JvmName("rijncelaksbaaiks")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the SKU capability.
     */
    @JvmName("wdmcgxjkitvkrsgc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reason of the SKU capability.
     */
    @JvmName("soopsphuebfgpgli")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    /**
     * @param value Value of the SKU capability.
     */
    @JvmName("oggpifopnkfudumr")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CapabilityArgs = CapabilityArgs(
        name = name,
        reason = reason,
        `value` = `value`,
    )
}
