@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ClientRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the app registration for providers that have client ids and client secrets
 * @property clientId The Client ID of the app used for login.
 * @property clientSecretSettingName The app setting name that contains the client secret.
 */
public data class ClientRegistrationArgs(
    public val clientId: Output<String>? = null,
    public val clientSecretSettingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ClientRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ClientRegistrationArgs =
        com.pulumi.azurenative.web.inputs.ClientRegistrationArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecretSettingName(clientSecretSettingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientRegistrationArgs].
 */
@PulumiTagMarker
public class ClientRegistrationArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecretSettingName: Output<String>? = null

    /**
     * @param value The Client ID of the app used for login.
     */
    @JvmName("wpjhhcxucdyvpttg")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The app setting name that contains the client secret.
     */
    @JvmName("arqbobkjgjrigbxi")
    public suspend fun clientSecretSettingName(`value`: Output<String>) {
        this.clientSecretSettingName = value
    }

    /**
     * @param value The Client ID of the app used for login.
     */
    @JvmName("ksetywotocjdabxm")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The app setting name that contains the client secret.
     */
    @JvmName("brcsosfdnchgncrp")
    public suspend fun clientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretSettingName = mapped
    }

    internal fun build(): ClientRegistrationArgs = ClientRegistrationArgs(
        clientId = clientId,
        clientSecretSettingName = clientSecretSettingName,
    )
}
