@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ConnectionGatewayReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The gateway installation reference
 * @property id Resource reference id
 * @property location Resource reference location
 * @property name Resource reference name
 * @property type Resource reference type
 */
public data class ConnectionGatewayReferenceArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ConnectionGatewayReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ConnectionGatewayReferenceArgs =
        com.pulumi.azurenative.web.inputs.ConnectionGatewayReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionGatewayReferenceArgs].
 */
@PulumiTagMarker
public class ConnectionGatewayReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Resource reference id
     */
    @JvmName("pbtdrqyxrchlujos")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource reference location
     */
    @JvmName("qsgumqsijuvppvau")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource reference name
     */
    @JvmName("uauoamoqsfcllwob")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource reference type
     */
    @JvmName("jhmrqufoluatmfor")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Resource reference id
     */
    @JvmName("vmihsffolceuyemg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource reference location
     */
    @JvmName("lycprcsecqjlacqb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource reference name
     */
    @JvmName("sfwnoyhgylqrfijq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource reference type
     */
    @JvmName("yekxyyrbcfopfayg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnectionGatewayReferenceArgs = ConnectionGatewayReferenceArgs(
        id = id,
        location = location,
        name = name,
        type = type,
    )
}
