@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ContainerAppsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appSubnetResourceId Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
 * @property controlPlaneSubnetResourceId Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
 * @property daprAIInstrumentationKey Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
 * @property dockerBridgeCidr CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
 * @property platformReservedCidr IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
 * @property platformReservedDnsIP An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
 */
public data class ContainerAppsConfigurationArgs(
    public val appSubnetResourceId: Output<String>? = null,
    public val controlPlaneSubnetResourceId: Output<String>? = null,
    public val daprAIInstrumentationKey: Output<String>? = null,
    public val dockerBridgeCidr: Output<String>? = null,
    public val platformReservedCidr: Output<String>? = null,
    public val platformReservedDnsIP: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ContainerAppsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ContainerAppsConfigurationArgs =
        com.pulumi.azurenative.web.inputs.ContainerAppsConfigurationArgs.builder()
            .appSubnetResourceId(appSubnetResourceId?.applyValue({ args0 -> args0 }))
            .controlPlaneSubnetResourceId(controlPlaneSubnetResourceId?.applyValue({ args0 -> args0 }))
            .daprAIInstrumentationKey(daprAIInstrumentationKey?.applyValue({ args0 -> args0 }))
            .dockerBridgeCidr(dockerBridgeCidr?.applyValue({ args0 -> args0 }))
            .platformReservedCidr(platformReservedCidr?.applyValue({ args0 -> args0 }))
            .platformReservedDnsIP(platformReservedDnsIP?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerAppsConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerAppsConfigurationArgsBuilder internal constructor() {
    private var appSubnetResourceId: Output<String>? = null

    private var controlPlaneSubnetResourceId: Output<String>? = null

    private var daprAIInstrumentationKey: Output<String>? = null

    private var dockerBridgeCidr: Output<String>? = null

    private var platformReservedCidr: Output<String>? = null

    private var platformReservedDnsIP: Output<String>? = null

    /**
     * @param value Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
     */
    @JvmName("pbpiacuntkttbrnq")
    public suspend fun appSubnetResourceId(`value`: Output<String>) {
        this.appSubnetResourceId = value
    }

    /**
     * @param value Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
     */
    @JvmName("nywbpdekvfymajdq")
    public suspend fun controlPlaneSubnetResourceId(`value`: Output<String>) {
        this.controlPlaneSubnetResourceId = value
    }

    /**
     * @param value Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("svahoasjspypadxh")
    public suspend fun daprAIInstrumentationKey(`value`: Output<String>) {
        this.daprAIInstrumentationKey = value
    }

    /**
     * @param value CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     */
    @JvmName("uiqcsjflxlyvdxij")
    public suspend fun dockerBridgeCidr(`value`: Output<String>) {
        this.dockerBridgeCidr = value
    }

    /**
     * @param value IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     */
    @JvmName("xqvgudhoalvamhvk")
    public suspend fun platformReservedCidr(`value`: Output<String>) {
        this.platformReservedCidr = value
    }

    /**
     * @param value An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
     */
    @JvmName("fbamorhnupdyhrwg")
    public suspend fun platformReservedDnsIP(`value`: Output<String>) {
        this.platformReservedDnsIP = value
    }

    /**
     * @param value Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
     */
    @JvmName("naltqtnrjyxstxtd")
    public suspend fun appSubnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSubnetResourceId = mapped
    }

    /**
     * @param value Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
     */
    @JvmName("cahpxitpncsmanli")
    public suspend fun controlPlaneSubnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneSubnetResourceId = mapped
    }

    /**
     * @param value Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    @JvmName("snhjmschkchvtlqg")
    public suspend fun daprAIInstrumentationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daprAIInstrumentationKey = mapped
    }

    /**
     * @param value CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
     */
    @JvmName("nmuhqlogdbhccrmq")
    public suspend fun dockerBridgeCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerBridgeCidr = mapped
    }

    /**
     * @param value IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
     */
    @JvmName("okuhxqnpipcayeem")
    public suspend fun platformReservedCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformReservedCidr = mapped
    }

    /**
     * @param value An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
     */
    @JvmName("aoxtexywwkcsqgpj")
    public suspend fun platformReservedDnsIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformReservedDnsIP = mapped
    }

    internal fun build(): ContainerAppsConfigurationArgs = ContainerAppsConfigurationArgs(
        appSubnetResourceId = appSubnetResourceId,
        controlPlaneSubnetResourceId = controlPlaneSubnetResourceId,
        daprAIInstrumentationKey = daprAIInstrumentationKey,
        dockerBridgeCidr = dockerBridgeCidr,
        platformReservedCidr = platformReservedCidr,
        platformReservedDnsIP = platformReservedDnsIP,
    )
}
