@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.DatabaseBackupSettingArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.DatabaseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Database backup settings.
 * @property connectionString Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
 * @property connectionStringName Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
 * This is used during restore with overwrite connection strings options.
 * @property databaseType Database type (e.g. SqlAzure / MySql).
 * @property name
 */
public data class DatabaseBackupSettingArgs(
    public val connectionString: Output<String>? = null,
    public val connectionStringName: Output<String>? = null,
    public val databaseType: Output<Either<String, DatabaseType>>,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.DatabaseBackupSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.DatabaseBackupSettingArgs =
        com.pulumi.azurenative.web.inputs.DatabaseBackupSettingArgs.builder()
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .connectionStringName(connectionStringName?.applyValue({ args0 -> args0 }))
            .databaseType(
                databaseType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseBackupSettingArgs].
 */
@PulumiTagMarker
public class DatabaseBackupSettingArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    private var connectionStringName: Output<String>? = null

    private var databaseType: Output<Either<String, DatabaseType>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
     */
    @JvmName("ymqdibajgicqjvjq")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
     * This is used during restore with overwrite connection strings options.
     */
    @JvmName("dxlfapegvpnkqpek")
    public suspend fun connectionStringName(`value`: Output<String>) {
        this.connectionStringName = value
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("qyrwrwxshxppyhqb")
    public suspend fun databaseType(`value`: Output<Either<String, DatabaseType>>) {
        this.databaseType = value
    }

    /**
     * @param value
     */
    @JvmName("awgowbnlyaquyclk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
     */
    @JvmName("ysxaqwpsmadsfprq")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
     * This is used during restore with overwrite connection strings options.
     */
    @JvmName("rypmgbvgivewprmo")
    public suspend fun connectionStringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringName = mapped
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("lwsryhjhfupweojj")
    public suspend fun databaseType(`value`: Either<String, DatabaseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("hoprjredvjcwyupc")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Database type (e.g. SqlAzure / MySql).
     */
    @JvmName("pqudktgucsgjiwjo")
    public fun databaseType(`value`: DatabaseType) {
        val toBeMapped = Either.ofRight<String, DatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value
     */
    @JvmName("repbahslufvamebv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DatabaseBackupSettingArgs = DatabaseBackupSettingArgs(
        connectionString = connectionString,
        connectionStringName = connectionStringName,
        databaseType = databaseType ?: throw PulumiNullFieldException("databaseType"),
        name = name,
    )
}
