@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the App Service Environment.
 * @property privateEndpointConnectionName Name of the private endpoint connection.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs(
    public val name: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgsBuilder internal
constructor() {
    private var name: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the App Service Environment.
     */
    @JvmName("tdesderuhyklohak")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the private endpoint connection.
     */
    @JvmName("mhylbjmxhjrgqqcm")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ofcraqwcoswmhlrx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs =
        GetAppServiceEnvironmentPrivateEndpointConnectionPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
