@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetConnectionGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionGatewayName The connection gateway name
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 */
public data class GetConnectionGatewayPlainArgs(
    public val connectionGatewayName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetConnectionGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetConnectionGatewayPlainArgs =
        com.pulumi.azurenative.web.inputs.GetConnectionGatewayPlainArgs.builder()
            .connectionGatewayName(connectionGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionGatewayPlainArgsBuilder internal constructor() {
    private var connectionGatewayName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value The connection gateway name
     */
    @JvmName("bopjoymmhexbrwuh")
    public suspend fun connectionGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionGatewayName = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("swjcuigugaojolad")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("jopnnfxddmbtdwks")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetConnectionGatewayPlainArgs = GetConnectionGatewayPlainArgs(
        connectionGatewayName = connectionGatewayName ?: throw
            PulumiNullFieldException("connectionGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
