@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetCustomApiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiName API name
 * @property resourceGroupName The resource group
 * @property subscriptionId Subscription Id
 */
public data class GetCustomApiPlainArgs(
    public val apiName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetCustomApiPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetCustomApiPlainArgs =
        com.pulumi.azurenative.web.inputs.GetCustomApiPlainArgs.builder()
            .apiName(apiName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCustomApiPlainArgs].
 */
@PulumiTagMarker
public class GetCustomApiPlainArgsBuilder internal constructor() {
    private var apiName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value API name
     */
    @JvmName("hhjnnecmqylokiqp")
    public suspend fun apiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiName = mapped
    }

    /**
     * @param value The resource group
     */
    @JvmName("pjwmutacnpqurkml")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Subscription Id
     */
    @JvmName("qvnoxhdeyihamqcb")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetCustomApiPlainArgs = GetCustomApiPlainArgs(
        apiName = apiName ?: throw PulumiNullFieldException("apiName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
