@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainOwnershipIdentifierName Name of domain ownership identifier.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
 */
public data class GetWebAppDomainOwnershipIdentifierSlotPlainArgs(
    public val domainOwnershipIdentifierName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierSlotPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierSlotPlainArgs.builder()
            .domainOwnershipIdentifierName(domainOwnershipIdentifierName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppDomainOwnershipIdentifierSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppDomainOwnershipIdentifierSlotPlainArgsBuilder internal constructor() {
    private var domainOwnershipIdentifierName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of domain ownership identifier.
     */
    @JvmName("myeasyccdmeejacl")
    public suspend fun domainOwnershipIdentifierName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainOwnershipIdentifierName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("jhorutanyiciqsdo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("mnxuwjvkkeqprxbs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
     */
    @JvmName("tjnxoafwjrpaknbb")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppDomainOwnershipIdentifierSlotPlainArgs =
        GetWebAppDomainOwnershipIdentifierSlotPlainArgs(
            domainOwnershipIdentifierName = domainOwnershipIdentifierName ?: throw
                PulumiNullFieldException("domainOwnershipIdentifierName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
