@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the web app.
 * @property namespaceName The namespace for this hybrid connection.
 * @property relayName The relay name for this hybrid connection.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot The name of the slot for the web app.
 */
public data class GetWebAppHybridConnectionSlotPlainArgs(
    public val name: String,
    public val namespaceName: String,
    public val relayName: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppHybridConnectionSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .relayName(relayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppHybridConnectionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppHybridConnectionSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var namespaceName: String? = null

    private var relayName: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value The name of the web app.
     */
    @JvmName("mytgswkhewpusljf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The namespace for this hybrid connection.
     */
    @JvmName("hbyhgsunjoythoah")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name for this hybrid connection.
     */
    @JvmName("tnrjtgekvhiycbbd")
    public suspend fun relayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relayName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("xxjahtqhbqiivrjt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the slot for the web app.
     */
    @JvmName("cabmlhbrstotfdlp")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppHybridConnectionSlotPlainArgs =
        GetWebAppHybridConnectionSlotPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            relayName = relayName ?: throw PulumiNullFieldException("relayName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
