@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property premierAddOnName Add-on name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will get the named add-on for the production slot.
 */
public data class GetWebAppPremierAddOnSlotPlainArgs(
    public val name: String,
    public val premierAddOnName: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .premierAddOnName(premierAddOnName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppPremierAddOnSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppPremierAddOnSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var premierAddOnName: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("saoiuyhyuhkcenmu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Add-on name.
     */
    @JvmName("gtrvttxwbkxmbekd")
    public suspend fun premierAddOnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.premierAddOnName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uuoukioytgpylryw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will get the named add-on for the production slot.
     */
    @JvmName("epgrsxledmcyxelv")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppPremierAddOnSlotPlainArgs = GetWebAppPremierAddOnSlotPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        premierAddOnName = premierAddOnName ?: throw PulumiNullFieldException("premierAddOnName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        slot = slot ?: throw PulumiNullFieldException("slot"),
    )
}
