@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property siteExtensionId Site extension name.
 */
public data class GetWebAppSiteExtensionPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val siteExtensionId: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteExtensionId(siteExtensionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppSiteExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppSiteExtensionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var siteExtensionId: String? = null

    /**
     * @param value Site name.
     */
    @JvmName("vvmdpogqgujgrfkc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("pmkvxdvraldlljum")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site extension name.
     */
    @JvmName("iscackcixwqyrrdg")
    public suspend fun siteExtensionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteExtensionId = mapped
    }

    internal fun build(): GetWebAppSiteExtensionPlainArgs = GetWebAppSiteExtensionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteExtensionId = siteExtensionId ?: throw PulumiNullFieldException("siteExtensionId"),
    )
}
