@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GitHubActionContainerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The GitHub action container configuration.
 * @property imageName The image name for the build.
 * @property password The password used to upload the image to the container registry.
 * @property serverUrl The server URL for the container registry where the build will be hosted.
 * @property username The username used to upload the image to the container registry.
 */
public data class GitHubActionContainerConfigurationArgs(
    public val imageName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val serverUrl: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GitHubActionContainerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GitHubActionContainerConfigurationArgs =
        com.pulumi.azurenative.web.inputs.GitHubActionContainerConfigurationArgs.builder()
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .serverUrl(serverUrl?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubActionContainerConfigurationArgs].
 */
@PulumiTagMarker
public class GitHubActionContainerConfigurationArgsBuilder internal constructor() {
    private var imageName: Output<String>? = null

    private var password: Output<String>? = null

    private var serverUrl: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The image name for the build.
     */
    @JvmName("wjausghvikdcxyxn")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The password used to upload the image to the container registry.
     */
    @JvmName("qtyyjpawqicfmcmu")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The server URL for the container registry where the build will be hosted.
     */
    @JvmName("mirjithqrllpyxpr")
    public suspend fun serverUrl(`value`: Output<String>) {
        this.serverUrl = value
    }

    /**
     * @param value The username used to upload the image to the container registry.
     */
    @JvmName("negmuujbjjnvxuun")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The image name for the build.
     */
    @JvmName("xugbpisgoklpkaft")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The password used to upload the image to the container registry.
     */
    @JvmName("qrnfcfkiqwrsqqcf")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The server URL for the container registry where the build will be hosted.
     */
    @JvmName("dlxitqcisfjnupli")
    public suspend fun serverUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverUrl = mapped
    }

    /**
     * @param value The username used to upload the image to the container registry.
     */
    @JvmName("ndoflwdiyyjvxref")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GitHubActionContainerConfigurationArgs =
        GitHubActionContainerConfigurationArgs(
            imageName = imageName,
            password = password,
            serverUrl = serverUrl,
            username = username,
        )
}
