@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.IdentityProvidersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
 * @property apple The configuration settings of the Apple provider.
 * @property azureActiveDirectory The configuration settings of the Azure Active directory provider.
 * @property azureStaticWebApps The configuration settings of the Azure Static Web Apps provider.
 * @property customOpenIdConnectProviders The map of the name of the alias of each custom Open ID Connect provider to the
 * configuration settings of the custom Open ID Connect provider.
 * @property facebook The configuration settings of the Facebook provider.
 * @property gitHub The configuration settings of the GitHub provider.
 * @property google The configuration settings of the Google provider.
 * @property legacyMicrosoftAccount The configuration settings of the legacy Microsoft Account provider.
 * @property twitter The configuration settings of the Twitter provider.
 */
public data class IdentityProvidersArgs(
    public val apple: Output<AppleArgs>? = null,
    public val azureActiveDirectory: Output<AzureActiveDirectoryArgs>? = null,
    public val azureStaticWebApps: Output<AzureStaticWebAppsArgs>? = null,
    public val customOpenIdConnectProviders: Output<Map<String, CustomOpenIdConnectProviderArgs>>? =
        null,
    public val facebook: Output<FacebookArgs>? = null,
    public val gitHub: Output<GitHubArgs>? = null,
    public val google: Output<GoogleArgs>? = null,
    public val legacyMicrosoftAccount: Output<LegacyMicrosoftAccountArgs>? = null,
    public val twitter: Output<TwitterArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.IdentityProvidersArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.IdentityProvidersArgs =
        com.pulumi.azurenative.web.inputs.IdentityProvidersArgs.builder()
            .apple(apple?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .azureActiveDirectory(
                azureActiveDirectory?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .azureStaticWebApps(
                azureStaticWebApps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customOpenIdConnectProviders(
                customOpenIdConnectProviders?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value.let({ args0 -> args0.toJava() })) }).toMap()
                }),
            )
            .facebook(facebook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .gitHub(gitHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .google(google?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .legacyMicrosoftAccount(
                legacyMicrosoftAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .twitter(twitter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IdentityProvidersArgs].
 */
@PulumiTagMarker
public class IdentityProvidersArgsBuilder internal constructor() {
    private var apple: Output<AppleArgs>? = null

    private var azureActiveDirectory: Output<AzureActiveDirectoryArgs>? = null

    private var azureStaticWebApps: Output<AzureStaticWebAppsArgs>? = null

    private var customOpenIdConnectProviders: Output<Map<String, CustomOpenIdConnectProviderArgs>>? =
        null

    private var facebook: Output<FacebookArgs>? = null

    private var gitHub: Output<GitHubArgs>? = null

    private var google: Output<GoogleArgs>? = null

    private var legacyMicrosoftAccount: Output<LegacyMicrosoftAccountArgs>? = null

    private var twitter: Output<TwitterArgs>? = null

    /**
     * @param value The configuration settings of the Apple provider.
     */
    @JvmName("bqxsugktjavygsfm")
    public suspend fun apple(`value`: Output<AppleArgs>) {
        this.apple = value
    }

    /**
     * @param value The configuration settings of the Azure Active directory provider.
     */
    @JvmName("jbxarprxadbwdito")
    public suspend fun azureActiveDirectory(`value`: Output<AzureActiveDirectoryArgs>) {
        this.azureActiveDirectory = value
    }

    /**
     * @param value The configuration settings of the Azure Static Web Apps provider.
     */
    @JvmName("jjtcjclunjnasuvx")
    public suspend fun azureStaticWebApps(`value`: Output<AzureStaticWebAppsArgs>) {
        this.azureStaticWebApps = value
    }

    /**
     * @param value The map of the name of the alias of each custom Open ID Connect provider to the
     * configuration settings of the custom Open ID Connect provider.
     */
    @JvmName("ochlmlymuofobpqt")
    public suspend
    fun customOpenIdConnectProviders(`value`: Output<Map<String, CustomOpenIdConnectProviderArgs>>) {
        this.customOpenIdConnectProviders = value
    }

    /**
     * @param value The configuration settings of the Facebook provider.
     */
    @JvmName("crlmrsbwgwedlprd")
    public suspend fun facebook(`value`: Output<FacebookArgs>) {
        this.facebook = value
    }

    /**
     * @param value The configuration settings of the GitHub provider.
     */
    @JvmName("mguuymkisfehicbj")
    public suspend fun gitHub(`value`: Output<GitHubArgs>) {
        this.gitHub = value
    }

    /**
     * @param value The configuration settings of the Google provider.
     */
    @JvmName("vsgneubbrgumiaey")
    public suspend fun google(`value`: Output<GoogleArgs>) {
        this.google = value
    }

    /**
     * @param value The configuration settings of the legacy Microsoft Account provider.
     */
    @JvmName("mdtjbqoqpjocrwed")
    public suspend fun legacyMicrosoftAccount(`value`: Output<LegacyMicrosoftAccountArgs>) {
        this.legacyMicrosoftAccount = value
    }

    /**
     * @param value The configuration settings of the Twitter provider.
     */
    @JvmName("xvafxvanvuddcmcm")
    public suspend fun twitter(`value`: Output<TwitterArgs>) {
        this.twitter = value
    }

    /**
     * @param value The configuration settings of the Apple provider.
     */
    @JvmName("xguolxawrvjdndlx")
    public suspend fun apple(`value`: AppleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apple = mapped
    }

    /**
     * @param argument The configuration settings of the Apple provider.
     */
    @JvmName("jldyklwwmwiwhgbn")
    public suspend fun apple(argument: suspend AppleArgsBuilder.() -> Unit) {
        val toBeMapped = AppleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apple = mapped
    }

    /**
     * @param value The configuration settings of the Azure Active directory provider.
     */
    @JvmName("mahetxlymfnvbocb")
    public suspend fun azureActiveDirectory(`value`: AzureActiveDirectoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureActiveDirectory = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Active directory provider.
     */
    @JvmName("fnwylitcnkcamxqh")
    public suspend
    fun azureActiveDirectory(argument: suspend AzureActiveDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureActiveDirectory = mapped
    }

    /**
     * @param value The configuration settings of the Azure Static Web Apps provider.
     */
    @JvmName("nphdjvgacstskhpm")
    public suspend fun azureStaticWebApps(`value`: AzureStaticWebAppsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStaticWebApps = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Static Web Apps provider.
     */
    @JvmName("abeydebvpoifanpa")
    public suspend
    fun azureStaticWebApps(argument: suspend AzureStaticWebAppsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureStaticWebAppsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureStaticWebApps = mapped
    }

    /**
     * @param value The map of the name of the alias of each custom Open ID Connect provider to the
     * configuration settings of the custom Open ID Connect provider.
     */
    @JvmName("pqypdclauootasfv")
    public suspend
    fun customOpenIdConnectProviders(`value`: Map<String, CustomOpenIdConnectProviderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customOpenIdConnectProviders = mapped
    }

    /**
     * @param argument The map of the name of the alias of each custom Open ID Connect provider to the
     * configuration settings of the custom Open ID Connect provider.
     */
    @JvmName("ijdvfhnikxknwrfk")
    public suspend fun customOpenIdConnectProviders(
        vararg
        argument: Pair<String, suspend CustomOpenIdConnectProviderArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                CustomOpenIdConnectProviderArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.customOpenIdConnectProviders = mapped
    }

    /**
     * @param values The map of the name of the alias of each custom Open ID Connect provider to the
     * configuration settings of the custom Open ID Connect provider.
     */
    @JvmName("scbgjnnnxrlepyjb")
    public fun customOpenIdConnectProviders(
        vararg
        values: Pair<String, CustomOpenIdConnectProviderArgs>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customOpenIdConnectProviders = mapped
    }

    /**
     * @param value The configuration settings of the Facebook provider.
     */
    @JvmName("qrclcmusdmltpwqp")
    public suspend fun facebook(`value`: FacebookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.facebook = mapped
    }

    /**
     * @param argument The configuration settings of the Facebook provider.
     */
    @JvmName("hebqnpqkhxacronp")
    public suspend fun facebook(argument: suspend FacebookArgsBuilder.() -> Unit) {
        val toBeMapped = FacebookArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.facebook = mapped
    }

    /**
     * @param value The configuration settings of the GitHub provider.
     */
    @JvmName("pcfeqjgocjwatmwk")
    public suspend fun gitHub(`value`: GitHubArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHub = mapped
    }

    /**
     * @param argument The configuration settings of the GitHub provider.
     */
    @JvmName("wbltytbjjrmqfakg")
    public suspend fun gitHub(argument: suspend GitHubArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitHub = mapped
    }

    /**
     * @param value The configuration settings of the Google provider.
     */
    @JvmName("nfbgpdyqvpuiyxtn")
    public suspend fun google(`value`: GoogleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.google = mapped
    }

    /**
     * @param argument The configuration settings of the Google provider.
     */
    @JvmName("fkblcrinldbayylh")
    public suspend fun google(argument: suspend GoogleArgsBuilder.() -> Unit) {
        val toBeMapped = GoogleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.google = mapped
    }

    /**
     * @param value The configuration settings of the legacy Microsoft Account provider.
     */
    @JvmName("nrdwmcplwpbtkwjh")
    public suspend fun legacyMicrosoftAccount(`value`: LegacyMicrosoftAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.legacyMicrosoftAccount = mapped
    }

    /**
     * @param argument The configuration settings of the legacy Microsoft Account provider.
     */
    @JvmName("ibtjgccmutctisge")
    public suspend
    fun legacyMicrosoftAccount(argument: suspend LegacyMicrosoftAccountArgsBuilder.() -> Unit) {
        val toBeMapped = LegacyMicrosoftAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.legacyMicrosoftAccount = mapped
    }

    /**
     * @param value The configuration settings of the Twitter provider.
     */
    @JvmName("smgjhqqldnpbgcmi")
    public suspend fun twitter(`value`: TwitterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.twitter = mapped
    }

    /**
     * @param argument The configuration settings of the Twitter provider.
     */
    @JvmName("ofqbkryualvqywxs")
    public suspend fun twitter(argument: suspend TwitterArgsBuilder.() -> Unit) {
        val toBeMapped = TwitterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.twitter = mapped
    }

    internal fun build(): IdentityProvidersArgs = IdentityProvidersArgs(
        apple = apple,
        azureActiveDirectory = azureActiveDirectory,
        azureStaticWebApps = azureStaticWebApps,
        customOpenIdConnectProviders = customOpenIdConnectProviders,
        facebook = facebook,
        gitHub = gitHub,
        google = google,
        legacyMicrosoftAccount = legacyMicrosoftAccount,
        twitter = twitter,
    )
}
