@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.JwtClaimChecksArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the checks that should be made while validating the JWT Claims.
 * @property allowedClientApplications The list of the allowed client applications.
 * @property allowedGroups The list of the allowed groups.
 */
public data class JwtClaimChecksArgs(
    public val allowedClientApplications: Output<List<String>>? = null,
    public val allowedGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.JwtClaimChecksArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.JwtClaimChecksArgs =
        com.pulumi.azurenative.web.inputs.JwtClaimChecksArgs.builder()
            .allowedClientApplications(
                allowedClientApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .allowedGroups(allowedGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [JwtClaimChecksArgs].
 */
@PulumiTagMarker
public class JwtClaimChecksArgsBuilder internal constructor() {
    private var allowedClientApplications: Output<List<String>>? = null

    private var allowedGroups: Output<List<String>>? = null

    /**
     * @param value The list of the allowed client applications.
     */
    @JvmName("smrbrgbpkchuyapr")
    public suspend fun allowedClientApplications(`value`: Output<List<String>>) {
        this.allowedClientApplications = value
    }

    @JvmName("elmkslbdpsnfxhfu")
    public suspend fun allowedClientApplications(vararg values: Output<String>) {
        this.allowedClientApplications = Output.all(values.asList())
    }

    /**
     * @param values The list of the allowed client applications.
     */
    @JvmName("xawdfthgblpngqwl")
    public suspend fun allowedClientApplications(values: List<Output<String>>) {
        this.allowedClientApplications = Output.all(values)
    }

    /**
     * @param value The list of the allowed groups.
     */
    @JvmName("pgnjedclptveoelc")
    public suspend fun allowedGroups(`value`: Output<List<String>>) {
        this.allowedGroups = value
    }

    @JvmName("jcoeibhsjhpyviiu")
    public suspend fun allowedGroups(vararg values: Output<String>) {
        this.allowedGroups = Output.all(values.asList())
    }

    /**
     * @param values The list of the allowed groups.
     */
    @JvmName("luubkkwxginvmoks")
    public suspend fun allowedGroups(values: List<Output<String>>) {
        this.allowedGroups = Output.all(values)
    }

    /**
     * @param value The list of the allowed client applications.
     */
    @JvmName("euvnjamnyvrwbxie")
    public suspend fun allowedClientApplications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedClientApplications = mapped
    }

    /**
     * @param values The list of the allowed client applications.
     */
    @JvmName("fuymwhvywqxknuhe")
    public suspend fun allowedClientApplications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedClientApplications = mapped
    }

    /**
     * @param value The list of the allowed groups.
     */
    @JvmName("ytvnvlqacxpbhpil")
    public suspend fun allowedGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedGroups = mapped
    }

    /**
     * @param values The list of the allowed groups.
     */
    @JvmName("ibkkhiphrnuacwnj")
    public suspend fun allowedGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedGroups = mapped
    }

    internal fun build(): JwtClaimChecksArgs = JwtClaimChecksArgs(
        allowedClientApplications = allowedClientApplications,
        allowedGroups = allowedGroups,
    )
}
