@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListStaticSiteBuildAppSettingsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName The stage site identifier.
 * @property name Name of the static site.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class ListStaticSiteBuildAppSettingsPlainArgs(
    public val environmentName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListStaticSiteBuildAppSettingsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListStaticSiteBuildAppSettingsPlainArgs =
        com.pulumi.azurenative.web.inputs.ListStaticSiteBuildAppSettingsPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStaticSiteBuildAppSettingsPlainArgs].
 */
@PulumiTagMarker
public class ListStaticSiteBuildAppSettingsPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The stage site identifier.
     */
    @JvmName("hfcwpoyifndjnoqu")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the static site.
     */
    @JvmName("pawinrislwjnwnug")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vxwhmxxptqprtpcd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListStaticSiteBuildAppSettingsPlainArgs =
        ListStaticSiteBuildAppSettingsPlainArgs(
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
