@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListWebAppBackupConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class ListWebAppBackupConfigurationPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListWebAppBackupConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListWebAppBackupConfigurationPlainArgs =
        com.pulumi.azurenative.web.inputs.ListWebAppBackupConfigurationPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWebAppBackupConfigurationPlainArgs].
 */
@PulumiTagMarker
public class ListWebAppBackupConfigurationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("ymkweuqrokfkecle")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("cnnvuciymantmefy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListWebAppBackupConfigurationPlainArgs =
        ListWebAppBackupConfigurationPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
