@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.LoginRoutesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The routes that specify the endpoints used for login and logout requests.
 * @property logoutEndpoint The endpoint at which a logout request should be made.
 */
public data class LoginRoutesArgs(
    public val logoutEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.LoginRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.LoginRoutesArgs =
        com.pulumi.azurenative.web.inputs.LoginRoutesArgs.builder()
            .logoutEndpoint(logoutEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoginRoutesArgs].
 */
@PulumiTagMarker
public class LoginRoutesArgsBuilder internal constructor() {
    private var logoutEndpoint: Output<String>? = null

    /**
     * @param value The endpoint at which a logout request should be made.
     */
    @JvmName("iwdmmlyaipjprcua")
    public suspend fun logoutEndpoint(`value`: Output<String>) {
        this.logoutEndpoint = value
    }

    /**
     * @param value The endpoint at which a logout request should be made.
     */
    @JvmName("ggfonwpwwffwkpfq")
    public suspend fun logoutEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logoutEndpoint = mapped
    }

    internal fun build(): LoginRoutesArgs = LoginRoutesArgs(
        logoutEndpoint = logoutEndpoint,
    )
}
