@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.LoginScopesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the login flow, including the scopes that should be requested.
 * @property scopes A list of the scopes that should be requested while authenticating.
 */
public data class LoginScopesArgs(
    public val scopes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.LoginScopesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.LoginScopesArgs =
        com.pulumi.azurenative.web.inputs.LoginScopesArgs.builder()
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [LoginScopesArgs].
 */
@PulumiTagMarker
public class LoginScopesArgsBuilder internal constructor() {
    private var scopes: Output<List<String>>? = null

    /**
     * @param value A list of the scopes that should be requested while authenticating.
     */
    @JvmName("pmfqilnsrnlpojoj")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("thdwmunbbmjnyllf")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A list of the scopes that should be requested while authenticating.
     */
    @JvmName("itfaktwqyyjoshjk")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value A list of the scopes that should be requested while authenticating.
     */
    @JvmName("vkjadpktvsngjuml")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values A list of the scopes that should be requested while authenticating.
     */
    @JvmName("vcvinrjxpyocfnmn")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    internal fun build(): LoginScopesArgs = LoginScopesArgs(
        scopes = scopes,
    )
}
