@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.OpenIdConnectLoginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the login flow of the custom Open ID Connect provider.
 * @property nameClaimType The name of the claim that contains the users name.
 * @property scopes A list of the scopes that should be requested while authenticating.
 */
public data class OpenIdConnectLoginArgs(
    public val nameClaimType: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.OpenIdConnectLoginArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.OpenIdConnectLoginArgs =
        com.pulumi.azurenative.web.inputs.OpenIdConnectLoginArgs.builder()
            .nameClaimType(nameClaimType?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [OpenIdConnectLoginArgs].
 */
@PulumiTagMarker
public class OpenIdConnectLoginArgsBuilder internal constructor() {
    private var nameClaimType: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    /**
     * @param value The name of the claim that contains the users name.
     */
    @JvmName("kuhepdmjqbkacxik")
    public suspend fun nameClaimType(`value`: Output<String>) {
        this.nameClaimType = value
    }

    /**
     * @param value A list of the scopes that should be requested while authenticating.
     */
    @JvmName("qdaiqegjoslewhnl")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("vegtxwjrhhreawxt")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A list of the scopes that should be requested while authenticating.
     */
    @JvmName("cdxlaehpecvvnptg")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The name of the claim that contains the users name.
     */
    @JvmName("ebvqngekmhtgcyhe")
    public suspend fun nameClaimType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameClaimType = mapped
    }

    /**
     * @param value A list of the scopes that should be requested while authenticating.
     */
    @JvmName("tvlswdkmuvgmxlnj")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values A list of the scopes that should be requested while authenticating.
     */
    @JvmName("thpetscgjuoulweo")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    internal fun build(): OpenIdConnectLoginArgs = OpenIdConnectLoginArgs(
        nameClaimType = nameClaimType,
        scopes = scopes,
    )
}
