@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App Secret.
 * @property name Secret Name.
 * @property value Secret Value.
 */
public data class SecretArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SecretArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SecretArgs =
        com.pulumi.azurenative.web.inputs.SecretArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Secret Name.
     */
    @JvmName("ftdbjhqqdeirxdnp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Secret Value.
     */
    @JvmName("tibefrtybnmsrifa")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Secret Name.
     */
    @JvmName("ufxwhvulwalxdobs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Secret Value.
     */
    @JvmName("jawifynwowvkmvtx")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        name = name,
        `value` = `value`,
    )
}
