@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.StaticSiteBuildPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Build properties for the static site.
 * @property apiBuildCommand A custom command to run during deployment of the Azure Functions API application.
 * @property apiLocation The path to the api code within the repository.
 * @property appArtifactLocation Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
 * @property appBuildCommand A custom command to run during deployment of the static content application.
 * @property appLocation The path to the app code within the repository.
 * @property githubActionSecretNameOverride Github Action secret name override.
 * @property outputLocation The output path of the app after building.
 * @property skipGithubActionWorkflowGeneration Skip Github Action workflow generation.
 */
public data class StaticSiteBuildPropertiesArgs(
    public val apiBuildCommand: Output<String>? = null,
    public val apiLocation: Output<String>? = null,
    public val appArtifactLocation: Output<String>? = null,
    public val appBuildCommand: Output<String>? = null,
    public val appLocation: Output<String>? = null,
    public val githubActionSecretNameOverride: Output<String>? = null,
    public val outputLocation: Output<String>? = null,
    public val skipGithubActionWorkflowGeneration: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.StaticSiteBuildPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.StaticSiteBuildPropertiesArgs =
        com.pulumi.azurenative.web.inputs.StaticSiteBuildPropertiesArgs.builder()
            .apiBuildCommand(apiBuildCommand?.applyValue({ args0 -> args0 }))
            .apiLocation(apiLocation?.applyValue({ args0 -> args0 }))
            .appArtifactLocation(appArtifactLocation?.applyValue({ args0 -> args0 }))
            .appBuildCommand(appBuildCommand?.applyValue({ args0 -> args0 }))
            .appLocation(appLocation?.applyValue({ args0 -> args0 }))
            .githubActionSecretNameOverride(githubActionSecretNameOverride?.applyValue({ args0 -> args0 }))
            .outputLocation(outputLocation?.applyValue({ args0 -> args0 }))
            .skipGithubActionWorkflowGeneration(
                skipGithubActionWorkflowGeneration?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StaticSiteBuildPropertiesArgs].
 */
@PulumiTagMarker
public class StaticSiteBuildPropertiesArgsBuilder internal constructor() {
    private var apiBuildCommand: Output<String>? = null

    private var apiLocation: Output<String>? = null

    private var appArtifactLocation: Output<String>? = null

    private var appBuildCommand: Output<String>? = null

    private var appLocation: Output<String>? = null

    private var githubActionSecretNameOverride: Output<String>? = null

    private var outputLocation: Output<String>? = null

    private var skipGithubActionWorkflowGeneration: Output<Boolean>? = null

    /**
     * @param value A custom command to run during deployment of the Azure Functions API application.
     */
    @JvmName("ppfqwgxrqymjsosv")
    public suspend fun apiBuildCommand(`value`: Output<String>) {
        this.apiBuildCommand = value
    }

    /**
     * @param value The path to the api code within the repository.
     */
    @JvmName("uboxtihsjxromyki")
    public suspend fun apiLocation(`value`: Output<String>) {
        this.apiLocation = value
    }

    /**
     * @param value Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
     */
    @JvmName("wrbymbmulnejhfpu")
    public suspend fun appArtifactLocation(`value`: Output<String>) {
        this.appArtifactLocation = value
    }

    /**
     * @param value A custom command to run during deployment of the static content application.
     */
    @JvmName("dvdmhwgnmwppegev")
    public suspend fun appBuildCommand(`value`: Output<String>) {
        this.appBuildCommand = value
    }

    /**
     * @param value The path to the app code within the repository.
     */
    @JvmName("puxodfgjvehknutd")
    public suspend fun appLocation(`value`: Output<String>) {
        this.appLocation = value
    }

    /**
     * @param value Github Action secret name override.
     */
    @JvmName("hfbovbexftuwhhaq")
    public suspend fun githubActionSecretNameOverride(`value`: Output<String>) {
        this.githubActionSecretNameOverride = value
    }

    /**
     * @param value The output path of the app after building.
     */
    @JvmName("phnhmobawmfrkedy")
    public suspend fun outputLocation(`value`: Output<String>) {
        this.outputLocation = value
    }

    /**
     * @param value Skip Github Action workflow generation.
     */
    @JvmName("wtyspmojkacknckx")
    public suspend fun skipGithubActionWorkflowGeneration(`value`: Output<Boolean>) {
        this.skipGithubActionWorkflowGeneration = value
    }

    /**
     * @param value A custom command to run during deployment of the Azure Functions API application.
     */
    @JvmName("eudoxsmvgbouxbti")
    public suspend fun apiBuildCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiBuildCommand = mapped
    }

    /**
     * @param value The path to the api code within the repository.
     */
    @JvmName("qixgkigpdtfprruu")
    public suspend fun apiLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiLocation = mapped
    }

    /**
     * @param value Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
     */
    @JvmName("pkhloxddxjgurvuo")
    public suspend fun appArtifactLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appArtifactLocation = mapped
    }

    /**
     * @param value A custom command to run during deployment of the static content application.
     */
    @JvmName("yuegxsfbmrlepuso")
    public suspend fun appBuildCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appBuildCommand = mapped
    }

    /**
     * @param value The path to the app code within the repository.
     */
    @JvmName("tsnywcvfqlyhxjmh")
    public suspend fun appLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appLocation = mapped
    }

    /**
     * @param value Github Action secret name override.
     */
    @JvmName("kbsbbqtgvqyrogay")
    public suspend fun githubActionSecretNameOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.githubActionSecretNameOverride = mapped
    }

    /**
     * @param value The output path of the app after building.
     */
    @JvmName("vbrmkoflcqopgdhy")
    public suspend fun outputLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputLocation = mapped
    }

    /**
     * @param value Skip Github Action workflow generation.
     */
    @JvmName("ovjfugsmtakcqhhl")
    public suspend fun skipGithubActionWorkflowGeneration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipGithubActionWorkflowGeneration = mapped
    }

    internal fun build(): StaticSiteBuildPropertiesArgs = StaticSiteBuildPropertiesArgs(
        apiBuildCommand = apiBuildCommand,
        apiLocation = apiLocation,
        appArtifactLocation = appArtifactLocation,
        appBuildCommand = appBuildCommand,
        appLocation = appLocation,
        githubActionSecretNameOverride = githubActionSecretNameOverride,
        outputLocation = outputLocation,
        skipGithubActionWorkflowGeneration = skipGithubActionWorkflowGeneration,
    )
}
