@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.VirtualDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Directory for virtual application.
 * @property physicalPath Physical path.
 * @property virtualPath Path to virtual application.
 */
public data class VirtualDirectoryArgs(
    public val physicalPath: Output<String>? = null,
    public val virtualPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.VirtualDirectoryArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.VirtualDirectoryArgs =
        com.pulumi.azurenative.web.inputs.VirtualDirectoryArgs.builder()
            .physicalPath(physicalPath?.applyValue({ args0 -> args0 }))
            .virtualPath(virtualPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualDirectoryArgs].
 */
@PulumiTagMarker
public class VirtualDirectoryArgsBuilder internal constructor() {
    private var physicalPath: Output<String>? = null

    private var virtualPath: Output<String>? = null

    /**
     * @param value Physical path.
     */
    @JvmName("qaxjavrxurabhddb")
    public suspend fun physicalPath(`value`: Output<String>) {
        this.physicalPath = value
    }

    /**
     * @param value Path to virtual application.
     */
    @JvmName("mlhmdginhgratlxv")
    public suspend fun virtualPath(`value`: Output<String>) {
        this.virtualPath = value
    }

    /**
     * @param value Physical path.
     */
    @JvmName("mobilcqpehfdneua")
    public suspend fun physicalPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalPath = mapped
    }

    /**
     * @param value Path to virtual application.
     */
    @JvmName("kbeetiydgnyjienl")
    public suspend fun virtualPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualPath = mapped
    }

    internal fun build(): VirtualDirectoryArgs = VirtualDirectoryArgs(
        physicalPath = physicalPath,
        virtualPath = virtualPath,
    )
}
