@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.VirtualNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specification for using a Virtual Network.
 * @property id Resource id of the Virtual Network.
 * @property subnet Subnet within the Virtual Network.
 */
public data class VirtualNetworkProfileArgs(
    public val id: Output<String>,
    public val subnet: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.VirtualNetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.VirtualNetworkProfileArgs =
        com.pulumi.azurenative.web.inputs.VirtualNetworkProfileArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkProfileArgs].
 */
@PulumiTagMarker
public class VirtualNetworkProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var subnet: Output<String>? = null

    /**
     * @param value Resource id of the Virtual Network.
     */
    @JvmName("tpkwttkrnlvigwbe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Subnet within the Virtual Network.
     */
    @JvmName("hnsqojkonoxatohs")
    public suspend fun subnet(`value`: Output<String>) {
        this.subnet = value
    }

    /**
     * @param value Resource id of the Virtual Network.
     */
    @JvmName("ftsvuhnxflnaelif")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Subnet within the Virtual Network.
     */
    @JvmName("nmeejuoamrkrlnpi")
    public suspend fun subnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    internal fun build(): VirtualNetworkProfileArgs = VirtualNetworkProfileArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        subnet = subnet,
    )
}
