@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.WsdlServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The service with name and endpoint names
 * @property endpointQualifiedNames List of the endpoints' qualified names
 * @property qualifiedName The service's qualified name
 */
public data class WsdlServiceArgs(
    public val endpointQualifiedNames: Output<List<String>>? = null,
    public val qualifiedName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.WsdlServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.WsdlServiceArgs =
        com.pulumi.azurenative.web.inputs.WsdlServiceArgs.builder()
            .endpointQualifiedNames(
                endpointQualifiedNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .qualifiedName(qualifiedName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WsdlServiceArgs].
 */
@PulumiTagMarker
public class WsdlServiceArgsBuilder internal constructor() {
    private var endpointQualifiedNames: Output<List<String>>? = null

    private var qualifiedName: Output<String>? = null

    /**
     * @param value List of the endpoints' qualified names
     */
    @JvmName("pkiofnqhnxntnecc")
    public suspend fun endpointQualifiedNames(`value`: Output<List<String>>) {
        this.endpointQualifiedNames = value
    }

    @JvmName("xtuiogtdgmqwoxjg")
    public suspend fun endpointQualifiedNames(vararg values: Output<String>) {
        this.endpointQualifiedNames = Output.all(values.asList())
    }

    /**
     * @param values List of the endpoints' qualified names
     */
    @JvmName("objukikovwkqgsdo")
    public suspend fun endpointQualifiedNames(values: List<Output<String>>) {
        this.endpointQualifiedNames = Output.all(values)
    }

    /**
     * @param value The service's qualified name
     */
    @JvmName("mpurtjwtmlxrtxks")
    public suspend fun qualifiedName(`value`: Output<String>) {
        this.qualifiedName = value
    }

    /**
     * @param value List of the endpoints' qualified names
     */
    @JvmName("xixelgqyemacwfyt")
    public suspend fun endpointQualifiedNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointQualifiedNames = mapped
    }

    /**
     * @param values List of the endpoints' qualified names
     */
    @JvmName("yyvbjrsctogjawde")
    public suspend fun endpointQualifiedNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointQualifiedNames = mapped
    }

    /**
     * @param value The service's qualified name
     */
    @JvmName("akcrytutikelsjqv")
    public suspend fun qualifiedName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.qualifiedName = mapped
    }

    internal fun build(): WsdlServiceArgs = WsdlServiceArgs(
        endpointQualifiedNames = endpointQualifiedNames,
        qualifiedName = qualifiedName ?: throw PulumiNullFieldException("qualifiedName"),
    )
}
