@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom action to be executed
 * when an auto heal rule is triggered.
 * @property exe Executable to be run.
 * @property parameters Parameters for the executable.
 */
public data class AutoHealCustomActionResponse(
    public val exe: String? = null,
    public val parameters: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AutoHealCustomActionResponse):
            AutoHealCustomActionResponse = AutoHealCustomActionResponse(
            exe = javaType.exe().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
        )
    }
}
