@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Files or Blob Storage access information value for dictionary storage.
 * @property accessKey Access key for the storage account.
 * @property accountName Name of the storage account.
 * @property mountPath Path to mount the storage within the site's runtime environment.
 * @property shareName Name of the file share (container name, for Blob storage).
 * @property state State of the storage account.
 * @property type Type of storage.
 */
public data class AzureStorageInfoValueResponse(
    public val accessKey: String? = null,
    public val accountName: String? = null,
    public val mountPath: String? = null,
    public val shareName: String? = null,
    public val state: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.AzureStorageInfoValueResponse):
            AzureStorageInfoValueResponse = AzureStorageInfoValueResponse(
            accessKey = javaType.accessKey().map({ args0 -> args0 }).orElse(null),
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            shareName = javaType.shareName().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
