@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A consent link
 * @property displayName Display name of the parameter in the connection provider's OAuth settings
 * @property firstPartyLoginUri URI for first party login
 * @property link URI for the consent link
 * @property status Status of the link
 */
public data class ConsentLinkDefinitionResponse(
    public val displayName: String? = null,
    public val firstPartyLoginUri: String? = null,
    public val link: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConsentLinkDefinitionResponse):
            ConsentLinkDefinitionResponse = ConsentLinkDefinitionResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            firstPartyLoginUri = javaType.firstPartyLoginUri().map({ args0 -> args0 }).orElse(null),
            link = javaType.link().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
