@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App container environment variable.
 * @property name Environment variable name.
 * @property secretRef Name of the Container App secret from which to pull the environment variable value.
 * @property value Non-secret environment variable value.
 */
public data class EnvironmentVarResponse(
    public val name: String? = null,
    public val secretRef: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.EnvironmentVarResponse):
            EnvironmentVarResponse = EnvironmentVarResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretRef = javaType.secretRef().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
