@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Slot Config names azure resource.
 * @property appSettingNames List of application settings names.
 * @property azureStorageConfigNames List of external Azure storage account identifiers.
 * @property connectionStringNames List of connection string names.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property type Resource type.
 */
public data class GetWebAppSlotConfigurationNamesResult(
    public val appSettingNames: List<String>? = null,
    public val azureStorageConfigNames: List<String>? = null,
    public val connectionStringNames: List<String>? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppSlotConfigurationNamesResult):
            GetWebAppSlotConfigurationNamesResult = GetWebAppSlotConfigurationNamesResult(
            appSettingNames = javaType.appSettingNames().map({ args0 -> args0 }),
            azureStorageConfigNames = javaType.azureStorageConfigNames().map({ args0 -> args0 }),
            connectionStringNames = javaType.connectionStringNames().map({ args0 -> args0 }),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
