@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specification for an App Service Environment to use for this resource.
 * @property id Resource ID of the App Service Environment.
 * @property name Name of the App Service Environment.
 * @property type Resource type of the App Service Environment.
 */
public data class HostingEnvironmentProfileResponse(
    public val id: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.HostingEnvironmentProfileResponse):
            HostingEnvironmentProfileResponse = HostingEnvironmentProfileResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
