@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Functions host level keys.
 * @property functionKeys Host level function keys.
 * @property masterKey Secret key.
 * @property systemKeys System keys.
 */
public data class ListWebAppHostKeysResult(
    public val functionKeys: Map<String, String>? = null,
    public val masterKey: String? = null,
    public val systemKeys: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppHostKeysResult):
            ListWebAppHostKeysResult = ListWebAppHostKeysResult(
            functionKeys = javaType.functionKeys().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            masterKey = javaType.masterKey().map({ args0 -> args0 }).orElse(null),
            systemKeys = javaType.systemKeys().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
