@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Collection of backup items.
 * @property nextLink Link to next page of resources.
 * @property value Collection of resources.
 */
public data class ListWebAppSiteBackupsResult(
    public val nextLink: String,
    public val `value`: List<BackupItemResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppSiteBackupsResult):
            ListWebAppSiteBackupsResult = ListWebAppSiteBackupsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.BackupItemResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
