@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.
 * @property actionHostName Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
 * @property changeDecisionCallbackUrl Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
 * https://www.siteextensions.net/packages/TiPCallback/
 * @property changeIntervalInMinutes Specifies interval in minutes to reevaluate ReroutePercentage.
 * @property changeStep In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \n<code>MinReroutePercentage</code> or
 * <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\nCustom decision algorithm
 * can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
 * @property maxReroutePercentage Specifies upper boundary below which ReroutePercentage will stay.
 * @property minReroutePercentage Specifies lower boundary above which ReroutePercentage will stay.
 * @property name Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
 * @property reroutePercentage Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
 */
public data class RampUpRuleResponse(
    public val actionHostName: String? = null,
    public val changeDecisionCallbackUrl: String? = null,
    public val changeIntervalInMinutes: Int? = null,
    public val changeStep: Double? = null,
    public val maxReroutePercentage: Double? = null,
    public val minReroutePercentage: Double? = null,
    public val name: String? = null,
    public val reroutePercentage: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.RampUpRuleResponse):
            RampUpRuleResponse = RampUpRuleResponse(
            actionHostName = javaType.actionHostName().map({ args0 -> args0 }).orElse(null),
            changeDecisionCallbackUrl = javaType.changeDecisionCallbackUrl().map({ args0 ->
                args0
            }).orElse(null),
            changeIntervalInMinutes = javaType.changeIntervalInMinutes().map({ args0 -> args0 }).orElse(null),
            changeStep = javaType.changeStep().map({ args0 -> args0 }).orElse(null),
            maxReroutePercentage = javaType.maxReroutePercentage().map({ args0 -> args0 }).orElse(null),
            minReroutePercentage = javaType.minReroutePercentage().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            reroutePercentage = javaType.reroutePercentage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
