@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App Private Registry
 * @property passwordSecretRef The name of the Secret that contains the registry login password
 * @property server Container Registry Server
 * @property username Container Registry Username
 */
public data class RegistryCredentialsResponse(
    public val passwordSecretRef: String? = null,
    public val server: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.RegistryCredentialsResponse):
            RegistryCredentialsResponse = RegistryCredentialsResponse(
            passwordSecretRef = javaType.passwordSecretRef().map({ args0 -> args0 }).orElse(null),
            server = javaType.server().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
