@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.kotlin.outputs.LiveTraceConfigurationResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ManagedIdentityResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceLogConfigurationResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceSkuResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SharedPrivateLinkResourceResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubNetworkACLsResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubTlsSettingsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.webpubsub.kotlin.outputs.LiveTraceConfigurationResponse.Companion.toKotlin as liveTraceConfigurationResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin as managedIdentityResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceLogConfigurationResponse.Companion.toKotlin as resourceLogConfigurationResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin as sharedPrivateLinkResourceResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubNetworkACLsResponse.Companion.toKotlin as webPubSubNetworkACLsResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubTlsSettingsResponse.Companion.toKotlin as webPubSubTlsSettingsResponseToKotlin

/**
 * Builder for [WebPubSub].
 */
@PulumiTagMarker
public class WebPubSubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebPubSubArgs = WebPubSubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebPubSubArgsBuilder.() -> Unit) {
        val builder = WebPubSubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebPubSub {
        val builtJavaResource = com.pulumi.azurenative.webpubsub.WebPubSub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebPubSub(builtJavaResource)
    }
}

/**
 * A class represent a resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2021-04-01-preview, 2021-06-01-preview, 2021-09-01-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### WebPubSub_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSub = new AzureNative.WebPubSub.WebPubSub("webPubSub", new()
 *     {
 *         DisableAadAuth = false,
 *         DisableLocalAuth = false,
 *         Identity = new AzureNative.WebPubSub.Inputs.ManagedIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         LiveTraceConfiguration = new AzureNative.WebPubSub.Inputs.LiveTraceConfigurationArgs
 *         {
 *             Categories = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.LiveTraceCategoryArgs
 *                 {
 *                     Enabled = "true",
 *                     Name = "ConnectivityLogs",
 *                 },
 *             },
 *             Enabled = "false",
 *         },
 *         Location = "eastus",
 *         NetworkACLs = new AzureNative.WebPubSub.Inputs.WebPubSubNetworkACLsArgs
 *         {
 *             DefaultAction = "Deny",
 *             PrivateEndpoints = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.PrivateEndpointACLArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         "ServerConnection",
 *                     },
 *                     Name = "mywebpubsubservice.1fa229cd-bf3f-47f0-8c49-afb36723997e",
 *                 },
 *             },
 *             PublicNetwork = new AzureNative.WebPubSub.Inputs.NetworkACLArgs
 *             {
 *                 Allow = new[]
 *                 {
 *                     "ClientConnection",
 *                 },
 *             },
 *         },
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *         Sku = new AzureNative.WebPubSub.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium_P1",
 *             Tier = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         Tls = new AzureNative.WebPubSub.Inputs.WebPubSubTlsSettingsArgs
 *         {
 *             ClientCertEnabled = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSub(ctx, "webPubSub", &webpubsub.WebPubSubArgs{
 * 			DisableAadAuth:   pulumi.Bool(false),
 * 			DisableLocalAuth: pulumi.Bool(false),
 * 			Identity: &webpubsub.ManagedIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			LiveTraceConfiguration: webpubsub.LiveTraceConfigurationResponse{
 * 				Categories: webpubsub.LiveTraceCategoryArray{
 * 					&webpubsub.LiveTraceCategoryArgs{
 * 						Enabled: pulumi.String("true"),
 * 						Name:    pulumi.String("ConnectivityLogs"),
 * 					},
 * 				},
 * 				Enabled: pulumi.String("false"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			NetworkACLs: webpubsub.WebPubSubNetworkACLsResponse{
 * 				DefaultAction: pulumi.String("Deny"),
 * 				PrivateEndpoints: webpubsub.PrivateEndpointACLArray{
 * 					&webpubsub.PrivateEndpointACLArgs{
 * 						Allow: pulumi.StringArray{
 * 							pulumi.String("ServerConnection"),
 * 						},
 * 						Name: pulumi.String("mywebpubsubservice.1fa229cd-bf3f-47f0-8c49-afb36723997e"),
 * 					},
 * 				},
 * 				PublicNetwork: &webpubsub.NetworkACLArgs{
 * 					Allow: pulumi.StringArray{
 * 						pulumi.String("ClientConnection"),
 * 					},
 * 				},
 * 			},
 * 			PublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ResourceName:        pulumi.String("myWebPubSubService"),
 * 			Sku: &webpubsub.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium_P1"),
 * 				Tier:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			Tls: &webpubsub.WebPubSubTlsSettingsArgs{
 * 				ClientCertEnabled: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSub;
 * import com.pulumi.azurenative.webpubsub.WebPubSubArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSub = new WebPubSub("webPubSub", WebPubSubArgs.builder()
 *             .disableAadAuth(false)
 *             .disableLocalAuth(false)
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .liveTraceConfiguration(Map.ofEntries(
 *                 Map.entry("categories", Map.ofEntries(
 *                     Map.entry("enabled", "true"),
 *                     Map.entry("name", "ConnectivityLogs")
 *                 )),
 *                 Map.entry("enabled", "false")
 *             ))
 *             .location("eastus")
 *             .networkACLs(Map.ofEntries(
 *                 Map.entry("defaultAction", "Deny"),
 *                 Map.entry("privateEndpoints", Map.ofEntries(
 *                     Map.entry("allow", "ServerConnection"),
 *                     Map.entry("name", "mywebpubsubservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
 *                 )),
 *                 Map.entry("publicNetwork", Map.of("allow", "ClientConnection"))
 *             ))
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium_P1"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .tls(Map.of("clientCertEnabled", false))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSub myWebPubSubService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}
 * ```
 */
public class WebPubSub internal constructor(
    override val javaResource: com.pulumi.azurenative.webpubsub.WebPubSub,
) : KotlinCustomResource(javaResource, WebPubSubMapper) {
    /**
     * DisableLocalAuth
     * Enable or disable aad auth
     * When set as true, connection with AuthType=aad won't work.
     */
    public val disableAadAuth: Output<Boolean>?
        get() = javaResource.disableAadAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DisableLocalAuth
     * Enable or disable local auth with AccessKey
     * When set as true, connection with AccessKey=xxx won't work.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The publicly accessible IP of the resource.
     */
    public val externalIP: Output<String>
        get() = javaResource.externalIP().applyValue({ args0 -> args0 })

    /**
     * FQDN of the service instance.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Deprecated.
     */
    public val hostNamePrefix: Output<String>
        get() = javaResource.hostNamePrefix().applyValue({ args0 -> args0 })

    /**
     * A class represent managed identities used for request and response
     */
    public val identity: Output<ManagedIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Live trace configuration of a Microsoft.SignalRService resource.
     */
    public val liveTraceConfiguration: Output<LiveTraceConfigurationResponse>?
        get() = javaResource.liveTraceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> liveTraceConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network ACLs for the resource
     */
    public val networkACLs: Output<WebPubSubNetworkACLsResponse>?
        get() = javaResource.networkACLs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webPubSubNetworkACLsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Private endpoint connections to the resource.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Enable or disable public network access. Default to "Enabled".
     * When it's Enabled, network ACLs still apply.
     * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The publicly accessible port of the resource which is designed for browser/client side usage.
     */
    public val publicPort: Output<Int>
        get() = javaResource.publicPort().applyValue({ args0 -> args0 })

    /**
     * Resource log configuration of a Microsoft.SignalRService resource.
     */
    public val resourceLogConfiguration: Output<ResourceLogConfigurationResponse>?
        get() = javaResource.resourceLogConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceLogConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The publicly accessible port of the resource which is designed for customer server side usage.
     */
    public val serverPort: Output<Int>
        get() = javaResource.serverPort().applyValue({ args0 -> args0 })

    /**
     * The list of shared private link resources.
     */
    public val sharedPrivateLinkResources: Output<List<SharedPrivateLinkResourceResponse>>
        get() = javaResource.sharedPrivateLinkResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sharedPrivateLinkResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The billing information of the resource.
     */
    public val sku: Output<ResourceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the service which is a list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * TLS settings for the resource
     */
    public val tls: Output<WebPubSubTlsSettingsResponse>?
        get() = javaResource.tls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webPubSubTlsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Version of the resource. Probably you need the same or higher version of client SDKs.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object WebPubSubMapper : ResourceMapper<WebPubSub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.webpubsub.WebPubSub::class == javaResource::class

    override fun map(javaResource: Resource): WebPubSub = WebPubSub(
        javaResource as
            com.pulumi.azurenative.webpubsub.WebPubSub,
    )
}

/**
 * @see [WebPubSub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebPubSub].
 */
public suspend fun webPubSub(name: String, block: suspend WebPubSubResourceBuilder.() -> Unit):
    WebPubSub {
    val builder = WebPubSubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebPubSub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webPubSub(name: String): WebPubSub {
    val builder = WebPubSubResourceBuilder()
    builder.name(name)
    return builder.build()
}
