@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.webpubsub.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WebPubSubCustomDomain].
 */
@PulumiTagMarker
public class WebPubSubCustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebPubSubCustomDomainArgs = WebPubSubCustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebPubSubCustomDomainArgsBuilder.() -> Unit) {
        val builder = WebPubSubCustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebPubSubCustomDomain {
        val builtJavaResource =
            com.pulumi.azurenative.webpubsub.WebPubSubCustomDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebPubSubCustomDomain(builtJavaResource)
    }
}

/**
 * A custom domain
 * Azure REST API version: 2023-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### WebPubSubCustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubCustomDomain = new AzureNative.WebPubSub.WebPubSubCustomDomain("webPubSubCustomDomain", new()
 *     {
 *         CustomCertificate = new AzureNative.WebPubSub.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/WebPubSub/myWebPubSubService/customCertificates/myCert",
 *         },
 *         DomainName = "example.com",
 *         Name = "myDomain",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubCustomDomain(ctx, "webPubSubCustomDomain", &webpubsub.WebPubSubCustomDomainArgs{
 * 			CustomCertificate: &webpubsub.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/WebPubSub/myWebPubSubService/customCertificates/myCert"),
 * 			},
 * 			DomainName:        pulumi.String("example.com"),
 * 			Name:              pulumi.String("myDomain"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myWebPubSubService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomDomain;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubCustomDomain = new WebPubSubCustomDomain("webPubSubCustomDomain", WebPubSubCustomDomainArgs.builder()
 *             .customCertificate(Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.SignalRService/WebPubSub/myWebPubSubService/customCertificates/myCert"))
 *             .domainName("example.com")
 *             .name("myDomain")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubCustomDomain myDomain /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/customDomains/{name}
 * ```
 */
public class WebPubSubCustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.webpubsub.WebPubSubCustomDomain,
) : KotlinCustomResource(javaResource, WebPubSubCustomDomainMapper) {
    /**
     * Reference to a resource.
     */
    public val customCertificate: Output<ResourceReferenceResponse>
        get() = javaResource.customCertificate().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceReferenceResponseToKotlin(args0)
            })
        })

    /**
     * The custom domain name.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebPubSubCustomDomainMapper : ResourceMapper<WebPubSubCustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.webpubsub.WebPubSubCustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): WebPubSubCustomDomain =
        WebPubSubCustomDomain(javaResource as com.pulumi.azurenative.webpubsub.WebPubSubCustomDomain)
}

/**
 * @see [WebPubSubCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebPubSubCustomDomain].
 */
public suspend fun webPubSubCustomDomain(
    name: String,
    block: suspend WebPubSubCustomDomainResourceBuilder.() -> Unit,
): WebPubSubCustomDomain {
    val builder = WebPubSubCustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebPubSubCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webPubSubCustomDomain(name: String): WebPubSubCustomDomain {
    val builder = WebPubSubCustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
