@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubCustomCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateName Custom certificate name
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class GetWebPubSubCustomCertificatePlainArgs(
    public val certificateName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubCustomCertificatePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubCustomCertificatePlainArgs =
        com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubCustomCertificatePlainArgs.builder()
            .certificateName(certificateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebPubSubCustomCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetWebPubSubCustomCertificatePlainArgsBuilder internal constructor() {
    private var certificateName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Custom certificate name
     */
    @JvmName("ccjmiidaecfhjbiw")
    public suspend fun certificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jetpmlnxaelxleol")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wximnxjaukmkrllo")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetWebPubSubCustomCertificatePlainArgs =
        GetWebPubSubCustomCertificatePlainArgs(
            certificateName = certificateName ?: throw PulumiNullFieldException("certificateName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
