@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubReplicaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replicaName The name of the replica.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource.
 */
public data class GetWebPubSubReplicaPlainArgs(
    public val replicaName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubReplicaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubReplicaPlainArgs =
        com.pulumi.azurenative.webpubsub.inputs.GetWebPubSubReplicaPlainArgs.builder()
            .replicaName(replicaName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebPubSubReplicaPlainArgs].
 */
@PulumiTagMarker
public class GetWebPubSubReplicaPlainArgsBuilder internal constructor() {
    private var replicaName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the replica.
     */
    @JvmName("nommmmllsmpbffby")
    public suspend fun replicaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicaName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ywjgwcoghevpdwyw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("uggrlgnevwxlmllp")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetWebPubSubReplicaPlainArgs = GetWebPubSubReplicaPlainArgs(
        replicaName = replicaName ?: throw PulumiNullFieldException("replicaName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
