@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.ResourceSkuArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.enums.WebPubSubSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The billing information of the resource.
 * @property capacity Optional, integer. The unit count of the resource. 1 by default.
 * If present, following values are allowed:
 *     Free: 1;
 *     Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
 *     Premium:  1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
 * @property name The name of the SKU. Required.
 * Allowed values: Standard_S1, Free_F1, Premium_P1
 * @property tier Optional tier of this particular SKU. 'Standard' or 'Free'.
 * `Basic` is deprecated, use `Standard` instead.
 */
public data class ResourceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>,
    public val tier: Output<Either<String, WebPubSubSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.ResourceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.ResourceSkuArgs =
        com.pulumi.azurenative.webpubsub.inputs.ResourceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceSkuArgs].
 */
@PulumiTagMarker
public class ResourceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<Either<String, WebPubSubSkuTier>>? = null

    /**
     * @param value Optional, integer. The unit count of the resource. 1 by default.
     * If present, following values are allowed:
     *     Free: 1;
     *     Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
     *     Premium:  1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
     */
    @JvmName("hojlspaasafqdhtp")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The name of the SKU. Required.
     * Allowed values: Standard_S1, Free_F1, Premium_P1
     */
    @JvmName("kobdanrdwcybnens")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Optional tier of this particular SKU. 'Standard' or 'Free'.
     * `Basic` is deprecated, use `Standard` instead.
     */
    @JvmName("hryqouaqaodpukpy")
    public suspend fun tier(`value`: Output<Either<String, WebPubSubSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Optional, integer. The unit count of the resource. 1 by default.
     * If present, following values are allowed:
     *     Free: 1;
     *     Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
     *     Premium:  1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
     */
    @JvmName("vgrkxowoxslicakd")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The name of the SKU. Required.
     * Allowed values: Standard_S1, Free_F1, Premium_P1
     */
    @JvmName("sbutyyclvwdaxkgp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Optional tier of this particular SKU. 'Standard' or 'Free'.
     * `Basic` is deprecated, use `Standard` instead.
     */
    @JvmName("onbyniqraujesajp")
    public suspend fun tier(`value`: Either<String, WebPubSubSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Optional tier of this particular SKU. 'Standard' or 'Free'.
     * `Basic` is deprecated, use `Standard` instead.
     */
    @JvmName("mhjfbedohikstrva")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebPubSubSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Optional tier of this particular SKU. 'Standard' or 'Free'.
     * `Basic` is deprecated, use `Standard` instead.
     */
    @JvmName("vypqafkhwbvftogy")
    public fun tier(`value`: WebPubSubSkuTier) {
        val toBeMapped = Either.ofRight<String, WebPubSubSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ResourceSkuArgs = ResourceSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
