@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.WebPubSubHubPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of a hub.
 * @property anonymousConnectPolicy The settings for configuring if anonymous connections are allowed for this hub: "allow" or "deny". Default to "deny".
 * @property eventHandlers Event handler of a hub.
 * @property eventListeners Event listener settings for forwarding your client events to listeners.
 * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
 * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
 * Maximum count of event listeners among all hubs is 10.
 */
public data class WebPubSubHubPropertiesArgs(
    public val anonymousConnectPolicy: Output<String>? = null,
    public val eventHandlers: Output<List<EventHandlerArgs>>? = null,
    public val eventListeners: Output<List<EventListenerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.WebPubSubHubPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.WebPubSubHubPropertiesArgs =
        com.pulumi.azurenative.webpubsub.inputs.WebPubSubHubPropertiesArgs.builder()
            .anonymousConnectPolicy(anonymousConnectPolicy?.applyValue({ args0 -> args0 }))
            .eventHandlers(
                eventHandlers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .eventListeners(
                eventListeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebPubSubHubPropertiesArgs].
 */
@PulumiTagMarker
public class WebPubSubHubPropertiesArgsBuilder internal constructor() {
    private var anonymousConnectPolicy: Output<String>? = null

    private var eventHandlers: Output<List<EventHandlerArgs>>? = null

    private var eventListeners: Output<List<EventListenerArgs>>? = null

    /**
     * @param value The settings for configuring if anonymous connections are allowed for this hub: "allow" or "deny". Default to "deny".
     */
    @JvmName("kjkgpuoqvcaohhnm")
    public suspend fun anonymousConnectPolicy(`value`: Output<String>) {
        this.anonymousConnectPolicy = value
    }

    /**
     * @param value Event handler of a hub.
     */
    @JvmName("uiwlbkchjegblhld")
    public suspend fun eventHandlers(`value`: Output<List<EventHandlerArgs>>) {
        this.eventHandlers = value
    }

    @JvmName("ybpynblmkuhmpnvn")
    public suspend fun eventHandlers(vararg values: Output<EventHandlerArgs>) {
        this.eventHandlers = Output.all(values.asList())
    }

    /**
     * @param values Event handler of a hub.
     */
    @JvmName("ipgrxedwhkbtjads")
    public suspend fun eventHandlers(values: List<Output<EventHandlerArgs>>) {
        this.eventHandlers = Output.all(values)
    }

    /**
     * @param value Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("uiotyuvbnkhsiylv")
    public suspend fun eventListeners(`value`: Output<List<EventListenerArgs>>) {
        this.eventListeners = value
    }

    @JvmName("opugdkqqpllakurb")
    public suspend fun eventListeners(vararg values: Output<EventListenerArgs>) {
        this.eventListeners = Output.all(values.asList())
    }

    /**
     * @param values Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("flbtiwoanbnshylq")
    public suspend fun eventListeners(values: List<Output<EventListenerArgs>>) {
        this.eventListeners = Output.all(values)
    }

    /**
     * @param value The settings for configuring if anonymous connections are allowed for this hub: "allow" or "deny". Default to "deny".
     */
    @JvmName("udjdfocvhkqpalms")
    public suspend fun anonymousConnectPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.anonymousConnectPolicy = mapped
    }

    /**
     * @param value Event handler of a hub.
     */
    @JvmName("pxnwfqircctqpunt")
    public suspend fun eventHandlers(`value`: List<EventHandlerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHandlers = mapped
    }

    /**
     * @param argument Event handler of a hub.
     */
    @JvmName("iuckejhsexscnsui")
    public suspend fun eventHandlers(argument: List<suspend EventHandlerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventHandlerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHandlers = mapped
    }

    /**
     * @param argument Event handler of a hub.
     */
    @JvmName("vmnjuhjqmxrkyfgk")
    public suspend fun eventHandlers(vararg argument: suspend EventHandlerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventHandlerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHandlers = mapped
    }

    /**
     * @param argument Event handler of a hub.
     */
    @JvmName("ulcudgallqedewkg")
    public suspend fun eventHandlers(argument: suspend EventHandlerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventHandlerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventHandlers = mapped
    }

    /**
     * @param values Event handler of a hub.
     */
    @JvmName("isgwudwryseufnby")
    public suspend fun eventHandlers(vararg values: EventHandlerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHandlers = mapped
    }

    /**
     * @param value Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("jqyqfsnobjqhfbkn")
    public suspend fun eventListeners(`value`: List<EventListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventListeners = mapped
    }

    /**
     * @param argument Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("cvetnectcaxlakxe")
    public suspend fun eventListeners(argument: List<suspend EventListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventListenerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventListeners = mapped
    }

    /**
     * @param argument Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("dpeldnjidouyicko")
    public suspend fun eventListeners(vararg argument: suspend EventListenerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventListenerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventListeners = mapped
    }

    /**
     * @param argument Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("fgwxconusgbugtdk")
    public suspend fun eventListeners(argument: suspend EventListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventListenerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventListeners = mapped
    }

    /**
     * @param values Event listener settings for forwarding your client events to listeners.
     * Event listener is transparent to Web PubSub clients, and it doesn't return any result to clients nor interrupt the lifetime of clients.
     * One event can be sent to multiple listeners, as long as it matches the filters in those listeners. The order of the array elements doesn't matter.
     * Maximum count of event listeners among all hubs is 10.
     */
    @JvmName("lkupwgoqybkfuqep")
    public suspend fun eventListeners(vararg values: EventListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventListeners = mapped
    }

    internal fun build(): WebPubSubHubPropertiesArgs = WebPubSubHubPropertiesArgs(
        anonymousConnectPolicy = anonymousConnectPolicy,
        eventHandlers = eventHandlers,
        eventListeners = eventListeners,
    )
}
