@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filter events by their name.
 * @property systemEvents Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not supported because it requires a response.
 * @property type
 * Expected value is 'EventName'.
 * @property userEventPattern Gets or sets a matching pattern for event names.
 * There are 3 kinds of patterns supported:
 *     1. "*", it matches any event name
 *     2. Combine multiple events with ",", for example "event1,event2", it matches events "event1" and "event2"
 *     3. A single event name, for example, "event1", it matches "event1"
 */
public data class EventNameFilterResponse(
    public val systemEvents: List<String>? = null,
    public val type: String,
    public val userEventPattern: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.EventNameFilterResponse):
            EventNameFilterResponse = EventNameFilterResponse(
            systemEvents = javaType.systemEvents().map({ args0 -> args0 }),
            type = javaType.type(),
            userEventPattern = javaType.userEventPattern().map({ args0 -> args0 }).orElse(null),
        )
    }
}
