@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class represents the access keys of the resource.
 * @property primaryConnectionString Connection string constructed via the primaryKey
 * @property primaryKey The primary access key.
 * @property secondaryConnectionString Connection string constructed via the secondaryKey
 * @property secondaryKey The secondary access key.
 */
public data class ListWebPubSubKeysResult(
    public val primaryConnectionString: String? = null,
    public val primaryKey: String? = null,
    public val secondaryConnectionString: String? = null,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.ListWebPubSubKeysResult):
            ListWebPubSubKeysResult = ListWebPubSubKeysResult(
            primaryConnectionString = javaType.primaryConnectionString().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            secondaryConnectionString = javaType.secondaryConnectionString().map({ args0 ->
                args0
            }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
