@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A class represent managed identities used for request and response
 * @property principalId Get the principal id for the system assigned identity.
 * Only be used in response.
 * @property tenantId Get the tenant id for the system assigned identity.
 * Only be used in response
 * @property type Represents the identity type: systemAssigned, userAssigned, None
 * @property userAssignedIdentities Get or set the user assigned identities
 */
public data class ManagedIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedIdentityPropertyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.ManagedIdentityResponse):
            ManagedIdentityResponse = ManagedIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.webpubsub.kotlin.outputs.UserAssignedIdentityPropertyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
