@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.windowsiot.kotlin.inputs

import com.pulumi.azurenative.windowsiot.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The name of the Windows IoT Device Service.
 * @property resourceGroupName The name of the resource group that contains the Windows IoT Device Service.
 */
public data class GetServicePlainArgs(
    public val deviceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.windowsiot.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.windowsiot.inputs.GetServicePlainArgs =
        com.pulumi.azurenative.windowsiot.inputs.GetServicePlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Windows IoT Device Service.
     */
    @JvmName("rosmkwbgtswnffqs")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the Windows IoT Device Service.
     */
    @JvmName("dvsxboksfpvopojb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
