@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.SapLandscapeMonitorArgs.builder
import com.pulumi.azurenative.workloads.kotlin.inputs.SapLandscapeMonitorMetricThresholdsArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.SapLandscapeMonitorMetricThresholdsArgsBuilder
import com.pulumi.azurenative.workloads.kotlin.inputs.SapLandscapeMonitorPropertiesGroupingArgs
import com.pulumi.azurenative.workloads.kotlin.inputs.SapLandscapeMonitorPropertiesGroupingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * configuration associated with SAP Landscape Monitor Dashboard.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create for SAP Landscape monitor Dashboard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapLandscapeMonitor = new AzureNative.Workloads.SapLandscapeMonitor("sapLandscapeMonitor", new()
 *     {
 *         Grouping = new AzureNative.Workloads.Inputs.SapLandscapeMonitorPropertiesGroupingArgs
 *         {
 *             Landscape = new[]
 *             {
 *                 new AzureNative.Workloads.Inputs.SapLandscapeMonitorSidMappingArgs
 *                 {
 *                     Name = "Prod",
 *                     TopSid = new[]
 *                     {
 *                         "SID1",
 *                         "SID2",
 *                     },
 *                 },
 *             },
 *             SapApplication = new[]
 *             {
 *                 new AzureNative.Workloads.Inputs.SapLandscapeMonitorSidMappingArgs
 *                 {
 *                     Name = "ERP1",
 *                     TopSid = new[]
 *                     {
 *                         "SID1",
 *                         "SID2",
 *                     },
 *                 },
 *             },
 *         },
 *         MonitorName = "mySapMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         TopMetricsThresholds = new[]
 *         {
 *             new AzureNative.Workloads.Inputs.SapLandscapeMonitorMetricThresholdsArgs
 *             {
 *                 Green = 90,
 *                 Name = "Instance Availability",
 *                 Red = 50,
 *                 Yellow = 75,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSapLandscapeMonitor(ctx, "sapLandscapeMonitor", &workloads.SapLandscapeMonitorArgs{
 * 			Grouping: workloads.SapLandscapeMonitorPropertiesResponseGrouping{
 * 				Landscape: workloads.SapLandscapeMonitorSidMappingArray{
 * 					&workloads.SapLandscapeMonitorSidMappingArgs{
 * 						Name: pulumi.String("Prod"),
 * 						TopSid: pulumi.StringArray{
 * 							pulumi.String("SID1"),
 * 							pulumi.String("SID2"),
 * 						},
 * 					},
 * 				},
 * 				SapApplication: workloads.SapLandscapeMonitorSidMappingArray{
 * 					&workloads.SapLandscapeMonitorSidMappingArgs{
 * 						Name: pulumi.String("ERP1"),
 * 						TopSid: pulumi.StringArray{
 * 							pulumi.String("SID1"),
 * 							pulumi.String("SID2"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			MonitorName:       pulumi.String("mySapMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			TopMetricsThresholds: []workloads.SapLandscapeMonitorMetricThresholdsArgs{
 * 				{
 * 					Green:  pulumi.Float64(90),
 * 					Name:   pulumi.String("Instance Availability"),
 * 					Red:    pulumi.Float64(50),
 * 					Yellow: pulumi.Float64(75),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SapLandscapeMonitor;
 * import com.pulumi.azurenative.workloads.SapLandscapeMonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapLandscapeMonitor = new SapLandscapeMonitor("sapLandscapeMonitor", SapLandscapeMonitorArgs.builder()
 *             .grouping(Map.ofEntries(
 *                 Map.entry("landscape", Map.ofEntries(
 *                     Map.entry("name", "Prod"),
 *                     Map.entry("topSid",
 *                         "SID1",
 *                         "SID2")
 *                 )),
 *                 Map.entry("sapApplication", Map.ofEntries(
 *                     Map.entry("name", "ERP1"),
 *                     Map.entry("topSid",
 *                         "SID1",
 *                         "SID2")
 *                 ))
 *             ))
 *             .monitorName("mySapMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .topMetricsThresholds(Map.ofEntries(
 *                 Map.entry("green", 90),
 *                 Map.entry("name", "Instance Availability"),
 *                 Map.entry("red", 50),
 *                 Map.entry("yellow", 75)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SapLandscapeMonitor default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/monitors/{monitorName}/sapLandscapeMonitor/default
 * ```
 * @property grouping Gets or sets the SID groupings by landscape and Environment.
 * @property monitorName Name of the SAP monitor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property topMetricsThresholds Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
 */
public data class SapLandscapeMonitorArgs(
    public val grouping: Output<SapLandscapeMonitorPropertiesGroupingArgs>? = null,
    public val monitorName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topMetricsThresholds: Output<List<SapLandscapeMonitorMetricThresholdsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.SapLandscapeMonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.SapLandscapeMonitorArgs =
        com.pulumi.azurenative.workloads.SapLandscapeMonitorArgs.builder()
            .grouping(grouping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topMetricsThresholds(
                topMetricsThresholds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SapLandscapeMonitorArgs].
 */
@PulumiTagMarker
public class SapLandscapeMonitorArgsBuilder internal constructor() {
    private var grouping: Output<SapLandscapeMonitorPropertiesGroupingArgs>? = null

    private var monitorName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var topMetricsThresholds: Output<List<SapLandscapeMonitorMetricThresholdsArgs>>? = null

    /**
     * @param value Gets or sets the SID groupings by landscape and Environment.
     */
    @JvmName("oyyefradjbgbayqv")
    public suspend fun grouping(`value`: Output<SapLandscapeMonitorPropertiesGroupingArgs>) {
        this.grouping = value
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("dlrpybgkbvnfarhw")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aqtevligmdqpseoh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("hbqxehkxgnrttyve")
    public suspend
    fun topMetricsThresholds(`value`: Output<List<SapLandscapeMonitorMetricThresholdsArgs>>) {
        this.topMetricsThresholds = value
    }

    @JvmName("fvrouxkfwcdlnyht")
    public suspend fun topMetricsThresholds(
        vararg
        values: Output<SapLandscapeMonitorMetricThresholdsArgs>,
    ) {
        this.topMetricsThresholds = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("mfhlcykrfeawyhxg")
    public suspend
    fun topMetricsThresholds(values: List<Output<SapLandscapeMonitorMetricThresholdsArgs>>) {
        this.topMetricsThresholds = Output.all(values)
    }

    /**
     * @param value Gets or sets the SID groupings by landscape and Environment.
     */
    @JvmName("tdidlphlkpjbcbdq")
    public suspend fun grouping(`value`: SapLandscapeMonitorPropertiesGroupingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param argument Gets or sets the SID groupings by landscape and Environment.
     */
    @JvmName("tjxuhrdhaqnwftrv")
    public suspend
    fun grouping(argument: suspend SapLandscapeMonitorPropertiesGroupingArgsBuilder.() -> Unit) {
        val toBeMapped = SapLandscapeMonitorPropertiesGroupingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("vlgfaxwbpsewbfrq")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jqvurwqvihehghnn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("byqjflouynhfkffa")
    public suspend fun topMetricsThresholds(`value`: List<SapLandscapeMonitorMetricThresholdsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topMetricsThresholds = mapped
    }

    /**
     * @param argument Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("jvmsctnajcjkjwmi")
    public suspend
    fun topMetricsThresholds(argument: List<suspend SapLandscapeMonitorMetricThresholdsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SapLandscapeMonitorMetricThresholdsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.topMetricsThresholds = mapped
    }

    /**
     * @param argument Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("bumonvkrpvkrqkvh")
    public suspend fun topMetricsThresholds(
        vararg
        argument: suspend SapLandscapeMonitorMetricThresholdsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SapLandscapeMonitorMetricThresholdsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.topMetricsThresholds = mapped
    }

    /**
     * @param argument Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("erphmaxvtrosnghx")
    public suspend
    fun topMetricsThresholds(argument: suspend SapLandscapeMonitorMetricThresholdsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SapLandscapeMonitorMetricThresholdsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.topMetricsThresholds = mapped
    }

    /**
     * @param values Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
     */
    @JvmName("qkwcervaqnjphyst")
    public suspend fun topMetricsThresholds(vararg values: SapLandscapeMonitorMetricThresholdsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topMetricsThresholds = mapped
    }

    internal fun build(): SapLandscapeMonitorArgs = SapLandscapeMonitorArgs(
        grouping = grouping,
        monitorName = monitorName,
        resourceGroupName = resourceGroupName,
        topMetricsThresholds = topMetricsThresholds,
    )
}
