@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Retention duration type: days/weeks/months/years
 * Used only if TieringMode is set to TierAfter
 */
public enum class RetentionDurationType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.RetentionDurationType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.RetentionDurationType> {
    Invalid(com.pulumi.azurenative.workloads.enums.RetentionDurationType.Invalid),
    Days(com.pulumi.azurenative.workloads.enums.RetentionDurationType.Days),
    Weeks(com.pulumi.azurenative.workloads.enums.RetentionDurationType.Weeks),
    Months(com.pulumi.azurenative.workloads.enums.RetentionDurationType.Months),
    Years(com.pulumi.azurenative.workloads.enums.RetentionDurationType.Years),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.RetentionDurationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.RetentionDurationType):
            RetentionDurationType = RetentionDurationType.values().first { it.javaValue == javaType }
    }
}
