@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the environment type - Production/Non Production.
 */
public enum class SAPEnvironmentType(
    public val javaValue: com.pulumi.azurenative.workloads.enums.SAPEnvironmentType,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.SAPEnvironmentType> {
    NonProd(com.pulumi.azurenative.workloads.enums.SAPEnvironmentType.NonProd),
    Prod(com.pulumi.azurenative.workloads.enums.SAPEnvironmentType.Prod),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.SAPEnvironmentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.SAPEnvironmentType):
            SAPEnvironmentType = SAPEnvironmentType.values().first { it.javaValue == javaType }
    }
}
