@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Tiering Mode to control automatic tiering of recovery points. Supported values are:
 * 1. TierRecommended: Tier all recovery points recommended to be tiered
 * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
 * 3. DoNotTier: Do not tier any recovery points
 */
public enum class TieringMode(
    public val javaValue: com.pulumi.azurenative.workloads.enums.TieringMode,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.TieringMode> {
    Invalid(com.pulumi.azurenative.workloads.enums.TieringMode.Invalid),
    TierRecommended(com.pulumi.azurenative.workloads.enums.TieringMode.TierRecommended),
    TierAfter(com.pulumi.azurenative.workloads.enums.TieringMode.TierAfter),
    DoNotTier(com.pulumi.azurenative.workloads.enums.TieringMode.DoNotTier),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.TieringMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.TieringMode): TieringMode =
            TieringMode.values().first { it.javaValue == javaType }
    }
}
